<#import "template.ftl" as layout>
<@layout.registrationLayout displayInfo=true; section>
	<#if section = "header">
		${msg("firebaseAuthTitle",realm.displayName)}
	<#elseif section = "form">
		<div class="${properties.kcFormClass!}">
			<!-- Standard MFA Verification Flow -->
			<h2>Mobile Verification Required</h2>
			<p>Please select the following code on your mobile device:</p>
			<div style="text-align: center; margin: 20px 0;">
				<div style="font-size: 3em; font-weight: bold; color: #0066cc; padding: 15px; background-color: #f0f8ff; border-radius: 8px; margin: 10px 0; border: 2px solid #0066cc;">
					${verificationCode!'XX'}
				</div>
			</div>
			<p style="text-align: center; color: #666;">Waiting for verification from your mobile device...</p>
		</div>

		<!-- JavaScript for MFA verification polling -->
		<script type="text/javascript">
			(function() {
				const sessionId = '${sessionId!''}';
				const realmName = '${realm.name!''}';
				const pollInterval = 2500;
				const maxPolls = 120;
				let pollCount = 0;

				if (!sessionId) {
					console.warn('No session ID found for Firebase MFA verification polling');
					return;
				}

				function pollVerificationStatus() {
					pollCount++;
					
					if (pollCount > maxPolls) {
						console.log('Firebase MFA verification polling timed out');
						return;
					}

					const xhr = new XMLHttpRequest();
					const url = '/realms/' + realmName + '/firebase-auth/session/' + sessionId + '/status';
					
					xhr.open('GET', url, true);
					xhr.setRequestHeader('Content-Type', 'application/json');
					
					xhr.onreadystatechange = function() {
						if (xhr.readyState === 4) {
							if (xhr.status === 200) {
								try {
									const response = JSON.parse(xhr.responseText);
									handleVerificationStatusResponse(response);
								} catch (e) {
									console.warn('Error parsing verification status response:', e);
									setTimeout(pollVerificationStatus, pollInterval);
								}
							} else {
								setTimeout(pollVerificationStatus, pollInterval);
							}
						}
					};
					
					xhr.send();
				}

				function handleVerificationStatusResponse(response) {
					console.log('Verification status:', response.status);
					
					if (response.status === 'verified') {
						console.log('MFA verification completed, reloading page');
						window.location.reload();
						return;
					} else if (response.status === 'expired') {
						console.log('MFA verification session expired');
						return;
					}
					
					setTimeout(pollVerificationStatus, pollInterval);
				}

				setTimeout(pollVerificationStatus, 1000);
			})();
		</script>
	<#elseif section = "info" >
		${msg("firebaseAuthInstruction")}
	</#if>
</@layout.registrationLayout>