<#import "template.ftl" as layout>
<@layout.registrationLayout displayInfo=true; section>
	<#if section = "header">
		${msg("firebaseRegisterTitle",realm.displayName)}
	<#elseif section = "form">
		<div class="${properties.kcFormClass!}">
			<!-- Force 2FA Registration Flow -->
			<h2>Mobile Device Registration Required</h2>
			<p>To enable two-factor authentication for your account, please open your mobile app and log in to register this device.</p>
			<div style="text-align: center; margin: 20px 0;">
				<div style="padding: 20px; background-color: #f5f5f5; border-radius: 8px; margin: 15px 0; border-left: 4px solid #0066cc;">
					<strong>Waiting for mobile registration...</strong>
					<br><small style="color: #666; margin-top: 5px;">This page will automatically continue once registration is complete.</small>
				</div>
			</div>
			
			<!-- Hidden session data for mobile app -->
			<script type="application/json" id="force2fa-session-data">
			{
				"session_id": "${sessionId!''}",
				"action": "force_2fa_registration",
				"realm": "${realm.name!''}"
			}
			</script>
		</div>

		<!-- JavaScript for registration polling -->
		<script type="text/javascript">
			(function() {
				const sessionId = '${sessionId!''}';
				const realmName = '${realm.name!''}';
				const pollInterval = 2500;
				const maxPolls = 120;
				let pollCount = 0;

				if (!sessionId) {
					console.warn('No session ID found for Force 2FA registration polling');
					return;
				}

				function pollRegistrationStatus() {
					pollCount++;
					
					if (pollCount > maxPolls) {
						console.log('Force 2FA registration polling timed out');
						return;
					}

					const xhr = new XMLHttpRequest();
					const url = '/realms/' + realmName + '/firebase-auth/session/' + sessionId + '/status';
					
					xhr.open('GET', url, true);
					xhr.setRequestHeader('Content-Type', 'application/json');
					
					xhr.onreadystatechange = function() {
						if (xhr.readyState === 4) {
							if (xhr.status === 200) {
								try {
									const response = JSON.parse(xhr.responseText);
									handleRegistrationStatusResponse(response);
								} catch (e) {
									console.warn('Error parsing registration status response:', e);
									setTimeout(pollRegistrationStatus, pollInterval);
								}
							} else {
								setTimeout(pollRegistrationStatus, pollInterval);
							}
						}
					};
					
					xhr.send();
				}

				function handleRegistrationStatusResponse(response) {
					console.log('Registration status:', response.status);
					
					if (response.status === 'fcm_registered' || response.fcm_token_registered) {
						console.log('Force 2FA registration completed, reloading page');
						window.location.reload();
						return;
					} else if (response.status === 'expired') {
						console.log('Force 2FA registration session expired');
						return;
					}
					
					setTimeout(pollRegistrationStatus, pollInterval);
				}

				setTimeout(pollRegistrationStatus, 1000);
			})();
		</script>
	<#elseif section = "info" >
		${msg("firebaseRegisterInstruction")}
	</#if>
</@layout.registrationLayout>