/*
 * Decompiled with CFR 0.152.
 */
package hive.keycloak.authenticator;

import com.google.common.base.Splitter;
import com.google.i18n.phonenumbers.NumberParseException;
import com.google.i18n.phonenumbers.PhoneNumberUtil;
import com.google.i18n.phonenumbers.Phonenumber;
import jakarta.ws.rs.core.Response;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.jboss.logging.Logger;
import org.keycloak.authentication.CredentialRegistrator;
import org.keycloak.authentication.InitiatedActionSupport;
import org.keycloak.authentication.RequiredActionContext;
import org.keycloak.authentication.RequiredActionProvider;
import org.keycloak.models.AuthenticatorConfigModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RoleModel;
import org.keycloak.models.UserModel;
import org.keycloak.sessions.AuthenticationSessionModel;

public class PhoneNumberRequiredAction
implements RequiredActionProvider,
CredentialRegistrator {
    public static final String PROVIDER_ID = "mobile_number_config";
    private static final Logger logger = Logger.getLogger(PhoneNumberRequiredAction.class);
    private static final Splitter numberFilterSplitter = Splitter.on((String)"##");
    private static final Pattern nonDigitPattern = Pattern.compile("[^0-9+]");
    private static final Pattern whitespacePattern = Pattern.compile("\\s+");

    public InitiatedActionSupport initiatedActionSupport() {
        return InitiatedActionSupport.SUPPORTED;
    }

    public void evaluateTriggers(RequiredActionContext context) {
        AuthenticatorConfigModel config = context.getRealm().getAuthenticatorConfigByAlias("sms-2fa");
        if (config == null) {
            logger.error((Object)"Failed to check 2FA enforcement, no config alias sms-2fa found");
            return;
        }
        boolean forceSecondFactorEnabled = Boolean.parseBoolean((String)config.getConfig().get("forceSecondFactor"));
        if (forceSecondFactorEnabled) {
            if (config.getConfig().get("whitelist") != null) {
                RoleModel whitelistRole = context.getRealm().getRole((String)config.getConfig().get("whitelist"));
                if (whitelistRole == null) {
                    logger.errorf("Failed configured whitelist role check [%s], make sure that the role exists", config.getConfig().get("whitelist"));
                } else if (context.getUser().hasRole(whitelistRole)) {
                    return;
                }
            }
            context.getAuthenticationSession().setAuthNote("mobileInputFieldPlaceholder", config.getConfig().getOrDefault("mobileInputFieldPlaceholder", ""));
            List<String> secondFactors = Arrays.asList("mobile-number", "webauthn", "otp");
            Stream credentials = context.getUser().credentialManager().getStoredCredentialsStream();
            if (credentials.anyMatch(x -> secondFactors.contains(x.getType()))) {
                return;
            }
            Set<String> availableRequiredActions = Set.of(PROVIDER_ID, "phone_validation_config", UserModel.RequiredAction.CONFIGURE_TOTP.name(), "webauthn-register", UserModel.RequiredAction.UPDATE_PASSWORD.name());
            Set authSessionRequiredActions = context.getAuthenticationSession().getRequiredActions();
            authSessionRequiredActions.retainAll(availableRequiredActions);
            if (!authSessionRequiredActions.isEmpty()) {
                return;
            }
            Stream usersRequiredActions = context.getUser().getRequiredActionsStream();
            if (usersRequiredActions.noneMatch(availableRequiredActions::contains)) {
                logger.infof("No 2FA method configured for user: %s, setting required action for SMS authenticator", (Object)context.getUser().getUsername());
                context.getUser().addRequiredAction(PROVIDER_ID);
            }
        }
    }

    public void requiredActionChallenge(RequiredActionContext context) {
        Response challenge = context.form().setAttribute("mobileInputFieldPlaceholder", (Object)context.getAuthenticationSession().getAuthNote("mobileInputFieldPlaceholder")).createForm("mobile_number_form.ftl");
        context.challenge(challenge);
    }

    public void processAction(RequiredActionContext context) {
        String mobileNumber = nonDigitPattern.matcher((CharSequence)context.getHttpRequest().getDecodedFormParameters().getFirst((Object)"mobile_number")).replaceAll("");
        AuthenticationSessionModel authSession = context.getAuthenticationSession();
        AuthenticatorConfigModel config = context.getRealm().getAuthenticatorConfigByAlias("sms-2fa");
        boolean normalizeNumber = false;
        boolean forceRetryOnBadFormat = false;
        if (config != null && config.getConfig() != null) {
            normalizeNumber = Boolean.parseBoolean(config.getConfig().getOrDefault("normalizePhoneNumber", "false"));
            forceRetryOnBadFormat = Boolean.parseBoolean(config.getConfig().getOrDefault("forceRetryOnBadFormat", "false"));
        }
        if (normalizeNumber) {
            String formattedNumber = this.formatPhoneNumber(context, mobileNumber);
            if (formattedNumber != null && !formattedNumber.isBlank()) {
                mobileNumber = formattedNumber;
            } else if (forceRetryOnBadFormat) {
                logger.errorf("Failed phone number formatting checks for: %s", (Object)mobileNumber);
                String formatError = context.getAuthenticationSession().getAuthNote("formatError");
                if (formatError != null && !formatError.isBlank()) {
                    this.handleInvalidNumber(context, formatError);
                    return;
                }
            }
        }
        authSession.setAuthNote("mobile_number", mobileNumber);
        logger.infof("Add required action for phone validation: [%s], user: %s", (Object)mobileNumber, (Object)context.getUser().getUsername());
        context.getAuthenticationSession().addRequiredAction("phone_validation_config");
        context.success();
    }

    private String formatPhoneNumber(RequiredActionContext context, String mobileNumber) {
        Phonenumber.PhoneNumber originalPhoneNumberParsed;
        int countryNumber;
        AuthenticatorConfigModel config = context.getRealm().getAuthenticatorConfigByAlias("sms-2fa");
        if (config == null || config.getConfig() == null) {
            logger.error((Object)"Failed format phone number, no config alias sms-2fa found");
            return mobileNumber;
        }
        PhoneNumberUtil phoneNumberUtil = PhoneNumberUtil.getInstance();
        try {
            countryNumber = Integer.parseInt(whitespacePattern.matcher(config.getConfig().getOrDefault("countrycode", "49").replace("+", "")).replaceAll(""));
        }
        catch (NumberFormatException e) {
            logger.warn((Object)"Failed to parse countrycode to int, using default value (49)", (Throwable)e);
            countryNumber = 49;
        }
        String nameCodeToUse = phoneNumberUtil.getRegionCodeForCountryCode(countryNumber);
        try {
            originalPhoneNumberParsed = phoneNumberUtil.parse(mobileNumber, nameCodeToUse);
        }
        catch (NumberParseException e) {
            logger.error((Object)"Failed to parse phone number", (Throwable)e);
            context.getAuthenticationSession().setAuthNote("formatError", "numberFormatFailedToParse");
            return null;
        }
        if (!phoneNumberUtil.isValidNumber(originalPhoneNumberParsed)) {
            logger.error((Object)"Phone number is not valid");
            context.getAuthenticationSession().setAuthNote("formatError", "numberFormatNumberInvalid");
            return null;
        }
        ArrayList numberTypeFilters = new ArrayList();
        String numberFiltersString = null;
        try {
            numberFiltersString = config.getConfig().getOrDefault("numberTypeFilters", "");
            if (!numberFiltersString.isBlank()) {
                numberFilterSplitter.splitToStream((CharSequence)numberFiltersString).forEach(filterString -> numberTypeFilters.add(PhoneNumberUtil.PhoneNumberType.valueOf(filterString)));
            }
        }
        catch (Exception e) {
            logger.errorf("Illegal filter found: %s. Filter must be a list of comma delimited Strings of FIXED_LINE, MOBILE, FIXED_LINE_OR_MOBILE, PAGER, TOLL_FREE, PREMIUM_RATE, SHARED_COST, PERSONAL_NUMBER, VOIP, UAN, VOICEMAIL", numberFiltersString);
            numberTypeFilters.clear();
        }
        if (!numberTypeFilters.isEmpty()) {
            PhoneNumberUtil.PhoneNumberType numberType = phoneNumberUtil.getNumberType(originalPhoneNumberParsed);
            if (numberTypeFilters.stream().noneMatch(filter -> filter == numberType)) {
                logger.errorf("Phone number type %s does not match any filters in %s", (Object)numberType.toString(), numberTypeFilters);
                context.getAuthenticationSession().setAuthNote("formatError", "numberFormatNoMatchingFilters");
                return null;
            }
        }
        return phoneNumberUtil.format(originalPhoneNumberParsed, PhoneNumberUtil.PhoneNumberFormat.E164);
    }

    private void handleInvalidNumber(RequiredActionContext context, String formatError) {
        Response challenge = context.form().setAttribute("mobileInputFieldPlaceholder", (Object)context.getAuthenticationSession().getAuthNote("mobileInputFieldPlaceholder")).setError(formatError, new Object[0]).createForm("mobile_number_form.ftl");
        context.challenge(challenge);
    }

    public void close() {
    }

    public String getCredentialType(KeycloakSession keycloakSession, AuthenticationSessionModel authenticationSessionModel) {
        return "mobile-number";
    }
}

