/*
 * Decompiled with CFR 0.152.
 */
package hive.keycloak.authenticator;

import hive.keycloak.authenticator.SmsAuthCredentialProvider;
import hive.keycloak.authenticator.credentials.SmsAuthCredentialModel;
import hive.keycloak.authenticator.gateway.SmsServiceFactory;
import jakarta.ws.rs.core.Response;
import java.util.Locale;
import org.jboss.logging.Logger;
import org.keycloak.authentication.CredentialRegistrator;
import org.keycloak.authentication.RequiredActionContext;
import org.keycloak.authentication.RequiredActionProvider;
import org.keycloak.common.util.SecretGenerator;
import org.keycloak.credential.CredentialInput;
import org.keycloak.credential.CredentialProvider;
import org.keycloak.models.AuthenticatorConfigModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserCredentialModel;
import org.keycloak.models.UserModel;
import org.keycloak.sessions.AuthenticationSessionModel;
import org.keycloak.theme.Theme;

public class PhoneValidationRequiredAction
implements RequiredActionProvider,
CredentialRegistrator {
    private static final Logger logger = Logger.getLogger(PhoneValidationRequiredAction.class);
    public static final String PROVIDER_ID = "phone_validation_config";

    public void evaluateTriggers(RequiredActionContext context) {
    }

    public void requiredActionChallenge(RequiredActionContext context) {
        context.getUser().addRequiredAction("mobile_number_config");
        try {
            UserModel user = context.getUser();
            RealmModel realm = context.getRealm();
            AuthenticationSessionModel authSession = context.getAuthenticationSession();
            AuthenticatorConfigModel config = context.getRealm().getAuthenticatorConfigByAlias("sms-2fa");
            String mobileNumber = authSession.getAuthNote("mobile_number");
            logger.infof("Validating phone number: %s of user: %s", (Object)mobileNumber, (Object)user.getUsername());
            int length = Integer.parseInt((String)config.getConfig().get("length"));
            int ttl = Integer.parseInt((String)config.getConfig().get("ttl"));
            String code = SecretGenerator.getInstance().randomString(length, SecretGenerator.DIGITS);
            authSession.setAuthNote("code", code);
            authSession.setAuthNote("ttl", Long.toString(System.currentTimeMillis() + (long)ttl * 1000L));
            Theme theme = context.getSession().theme().getTheme(Theme.Type.LOGIN);
            Locale locale = context.getSession().getContext().resolveLocale(user);
            String smsAuthText = theme.getEnhancedMessages(realm, locale).getProperty("smsAuthText");
            String smsText = String.format(smsAuthText, code, Math.floorDiv(ttl, 60));
            SmsServiceFactory.get(config.getConfig()).send(mobileNumber, smsText);
            Response challenge = context.form().setAttribute("realm", (Object)realm).createForm("login-sms.ftl");
            context.challenge(challenge);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            context.failure();
        }
    }

    public void processAction(RequiredActionContext context) {
        String enteredCode = (String)context.getHttpRequest().getDecodedFormParameters().getFirst((Object)"code");
        AuthenticationSessionModel authSession = context.getAuthenticationSession();
        String mobileNumber = authSession.getAuthNote("mobile_number");
        String code = authSession.getAuthNote("code");
        String ttl = authSession.getAuthNote("ttl");
        if (code == null || ttl == null || enteredCode == null) {
            logger.warn((Object)"Phone number is not set");
            this.handleInvalidSmsCode(context);
            return;
        }
        boolean isValid = enteredCode.equals(code);
        if (isValid && Long.parseLong(ttl) > System.currentTimeMillis()) {
            SmsAuthCredentialProvider smnp = (SmsAuthCredentialProvider)context.getSession().getProvider(CredentialProvider.class, "mobile-number");
            if (!smnp.isConfiguredFor(context.getRealm(), context.getUser(), "mobile-number")) {
                smnp.createCredential(context.getRealm(), context.getUser(), SmsAuthCredentialModel.createSmsAuthenticator(mobileNumber));
            } else {
                smnp.updateCredential(context.getRealm(), context.getUser(), (CredentialInput)new UserCredentialModel("random_id", "mobile-number", mobileNumber));
            }
            context.getUser().removeRequiredAction("mobile_number_config");
            this.handlePhoneToAttribute(context, mobileNumber);
            context.success();
        } else {
            this.handleInvalidSmsCode(context);
        }
    }

    private void handlePhoneToAttribute(RequiredActionContext context, String mobileNumber) {
        AuthenticatorConfigModel config = context.getRealm().getAuthenticatorConfigByAlias("sms-2fa");
        if (config == null) {
            logger.warn((Object)"No config alias sms-2fa found, skip phone number to attribute check");
        } else if (Boolean.parseBoolean((String)config.getConfig().get("storeInAttribute"))) {
            context.getUser().setSingleAttribute("mobile_number", mobileNumber);
        }
    }

    private void handleInvalidSmsCode(RequiredActionContext context) {
        Response challenge = context.form().setAttribute("realm", (Object)context.getRealm()).setError("smsAuthCodeInvalid", new Object[0]).createForm("login-sms.ftl");
        context.challenge(challenge);
    }

    public void close() {
    }

    public String getCredentialType(KeycloakSession keycloakSession, AuthenticationSessionModel authenticationSessionModel) {
        return "mobile-number";
    }
}

