/*
 * Decompiled with CFR 0.152.
 */
package hive.keycloak.authenticator;

import hive.keycloak.authenticator.credentials.SmsAuthCredentialModel;
import java.util.Optional;
import java.util.stream.Stream;
import org.keycloak.common.util.Time;
import org.keycloak.credential.CredentialInput;
import org.keycloak.credential.CredentialInputUpdater;
import org.keycloak.credential.CredentialInputValidator;
import org.keycloak.credential.CredentialModel;
import org.keycloak.credential.CredentialProvider;
import org.keycloak.credential.CredentialTypeMetadata;
import org.keycloak.credential.CredentialTypeMetadataContext;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserCredentialModel;
import org.keycloak.models.UserModel;

public class SmsAuthCredentialProvider
implements CredentialProvider<SmsAuthCredentialModel>,
CredentialInputValidator,
CredentialInputUpdater {
    protected final KeycloakSession session;

    public SmsAuthCredentialProvider(KeycloakSession session) {
        this.session = session;
    }

    public boolean isValid(RealmModel realm, UserModel user, CredentialInput input) {
        if (!(input instanceof UserCredentialModel)) {
            return false;
        }
        if (!input.getType().equals(this.getType())) {
            return false;
        }
        String challengeResponse = input.getChallengeResponse();
        if (challengeResponse == null) {
            return false;
        }
        CredentialModel credentialModel = user.credentialManager().getStoredCredentialById(input.getCredentialId());
        SmsAuthCredentialModel sqcm = this.getCredentialFromModel(credentialModel);
        return sqcm.getSmsAuthenticatorData().getMobileNumber().equals(challengeResponse);
    }

    public boolean supportsCredentialType(String credentialType) {
        return this.getType().equals(credentialType);
    }

    public boolean isConfiguredFor(RealmModel realm, UserModel user, String credentialType) {
        if (!this.supportsCredentialType(credentialType)) {
            return false;
        }
        return user.credentialManager().getStoredCredentialsByTypeStream(credentialType).findAny().isPresent();
    }

    public CredentialModel createCredential(RealmModel realm, UserModel user, SmsAuthCredentialModel credentialModel) {
        credentialModel.setCreatedDate(Time.currentTimeMillis());
        return user.credentialManager().createStoredCredential((CredentialModel)credentialModel);
    }

    public boolean updateCredential(RealmModel realm, UserModel user, CredentialInput input) {
        String mobileNumber = input.getChallengeResponse();
        Optional model = user.credentialManager().getStoredCredentialsByTypeStream(input.getType()).findFirst();
        if (model.isPresent()) {
            CredentialModel credentialModel = (CredentialModel)model.get();
            this.deleteCredential(realm, user, credentialModel.getId());
            this.createCredential(realm, user, SmsAuthCredentialModel.createSmsAuthenticator(mobileNumber));
            return true;
        }
        return false;
    }

    public boolean deleteCredential(RealmModel realm, UserModel user, String credentialId) {
        return user.credentialManager().removeStoredCredentialById(credentialId);
    }

    public SmsAuthCredentialModel getCredentialFromModel(CredentialModel model) {
        return SmsAuthCredentialModel.createFromModel(model);
    }

    public CredentialTypeMetadata getCredentialTypeMetadata(CredentialTypeMetadataContext metadataContext) {
        return CredentialTypeMetadata.builder().type(this.getType()).category(CredentialTypeMetadata.Category.TWO_FACTOR).displayName("smsAuthenticator").helpText("smsPhoneUpdate").createAction("mobile_number_config").removeable(true).build(this.session);
    }

    public String getType() {
        return "mobile-number";
    }

    public Stream<String> getDisableableCredentialTypesStream(RealmModel realm, UserModel user) {
        return Stream.empty();
    }

    public void disableCredentialType(RealmModel realm, UserModel user, String credentialType) {
    }
}

