/*
 * Decompiled with CFR 0.152.
 */
package hive.keycloak.authenticator;

import hive.keycloak.authenticator.PhoneNumberRequiredActionFactory;
import hive.keycloak.authenticator.SmsAuthCredentialProvider;
import hive.keycloak.authenticator.credentials.SmsAuthCredentialData;
import hive.keycloak.authenticator.gateway.SmsServiceFactory;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import org.jboss.logging.Logger;
import org.keycloak.authentication.AuthenticationFlowContext;
import org.keycloak.authentication.AuthenticationFlowError;
import org.keycloak.authentication.Authenticator;
import org.keycloak.authentication.CredentialValidator;
import org.keycloak.authentication.RequiredActionFactory;
import org.keycloak.authentication.RequiredActionProvider;
import org.keycloak.common.util.SecretGenerator;
import org.keycloak.credential.CredentialModel;
import org.keycloak.credential.CredentialProvider;
import org.keycloak.models.AuthenticationExecutionModel;
import org.keycloak.models.AuthenticatorConfigModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.sessions.AuthenticationSessionModel;
import org.keycloak.theme.Theme;
import org.keycloak.util.JsonSerialization;

public class SmsAuthenticator
implements Authenticator,
CredentialValidator<SmsAuthCredentialProvider> {
    private static final Logger logger = Logger.getLogger(SmsAuthenticator.class);
    private static final String TPL_CODE = "login-sms.ftl";

    public void authenticate(AuthenticationFlowContext context) {
        String mobileNumber;
        AuthenticatorConfigModel config = context.getAuthenticatorConfig();
        KeycloakSession session = context.getSession();
        UserModel user = context.getUser();
        RealmModel realm = context.getRealm();
        Optional model = context.getUser().credentialManager().getStoredCredentialsByTypeStream("mobile-number").findFirst();
        try {
            mobileNumber = ((SmsAuthCredentialData)JsonSerialization.readValue((String)((CredentialModel)model.orElseThrow()).getCredentialData(), SmsAuthCredentialData.class)).getMobileNumber();
        }
        catch (IOException e1) {
            logger.warn((Object)e1.getMessage(), (Throwable)e1);
            return;
        }
        int length = Integer.parseInt((String)config.getConfig().get("length"));
        int ttl = Integer.parseInt((String)config.getConfig().get("ttl"));
        String code = SecretGenerator.getInstance().randomString(length, SecretGenerator.DIGITS);
        AuthenticationSessionModel authSession = context.getAuthenticationSession();
        authSession.setAuthNote("code", code);
        authSession.setAuthNote("ttl", Long.toString(System.currentTimeMillis() + (long)ttl * 1000L));
        try {
            Theme theme = session.theme().getTheme(Theme.Type.LOGIN);
            Locale locale = session.getContext().resolveLocale(user);
            String smsAuthText = theme.getEnhancedMessages(realm, locale).getProperty("smsAuthText");
            String smsText = String.format(smsAuthText, code, Math.floorDiv(ttl, 60));
            SmsServiceFactory.get(config.getConfig()).send(mobileNumber, smsText);
            context.challenge(context.form().setAttribute("realm", (Object)realm).createForm(TPL_CODE));
        }
        catch (Exception e) {
            context.failureChallenge(AuthenticationFlowError.INTERNAL_ERROR, context.form().setError("smsAuthSmsNotSent", new Object[]{"Error. Use another method."}).createErrorPage(Response.Status.INTERNAL_SERVER_ERROR));
        }
    }

    public void action(AuthenticationFlowContext context) {
        String enteredCode = (String)context.getHttpRequest().getDecodedFormParameters().getFirst((Object)"code");
        AuthenticationSessionModel authSession = context.getAuthenticationSession();
        String code = authSession.getAuthNote("code");
        String ttl = authSession.getAuthNote("ttl");
        if (code == null || ttl == null) {
            context.failureChallenge(AuthenticationFlowError.INTERNAL_ERROR, context.form().createErrorPage(Response.Status.INTERNAL_SERVER_ERROR));
            return;
        }
        boolean isValid = enteredCode.equals(code);
        if (isValid) {
            if (Long.parseLong(ttl) < System.currentTimeMillis()) {
                context.failureChallenge(AuthenticationFlowError.EXPIRED_CODE, context.form().setError("smsAuthCodeExpired", new Object[0]).createErrorPage(Response.Status.BAD_REQUEST));
            } else {
                context.success();
            }
        } else {
            AuthenticationExecutionModel execution = context.getExecution();
            if (execution.isRequired()) {
                context.failureChallenge(AuthenticationFlowError.INVALID_CREDENTIALS, context.form().setAttribute("realm", (Object)context.getRealm()).setError("smsAuthCodeInvalid", new Object[0]).createForm(TPL_CODE));
            } else if (execution.isConditional() || execution.isAlternative()) {
                context.attempted();
            }
        }
    }

    public boolean requiresUser() {
        return true;
    }

    public boolean configuredFor(KeycloakSession session, RealmModel realm, UserModel user) {
        return this.getCredentialProvider(session).isConfiguredFor(realm, user, this.getType(session));
    }

    public void setRequiredActions(KeycloakSession session, RealmModel realm, UserModel user) {
        user.addRequiredAction("mobile_number_config");
    }

    public List<RequiredActionFactory> getRequiredActions(KeycloakSession session) {
        return Collections.singletonList((PhoneNumberRequiredActionFactory)session.getKeycloakSessionFactory().getProviderFactory(RequiredActionProvider.class, "mobile_number_config"));
    }

    public void close() {
    }

    public SmsAuthCredentialProvider getCredentialProvider(KeycloakSession session) {
        return (SmsAuthCredentialProvider)session.getProvider(CredentialProvider.class, "mobile-number");
    }
}

