/*
 * Decompiled with CFR 0.152.
 */
package hive.keycloak.authenticator.credentials;

import hive.keycloak.authenticator.credentials.SmsAuthCredentialData;
import java.io.IOException;
import org.keycloak.common.util.Time;
import org.keycloak.credential.CredentialModel;
import org.keycloak.util.JsonSerialization;

public class SmsAuthCredentialModel
extends CredentialModel {
    public static final String TYPE = "mobile-number";
    private final SmsAuthCredentialData mobileNumber;

    private SmsAuthCredentialModel(SmsAuthCredentialData mobileNumber) {
        this.mobileNumber = mobileNumber;
    }

    private SmsAuthCredentialModel(String mobileNumberString) {
        this.mobileNumber = new SmsAuthCredentialData(mobileNumberString);
    }

    public static SmsAuthCredentialModel createFromModel(CredentialModel credentialModel) {
        try {
            SmsAuthCredentialData credentialData = (SmsAuthCredentialData)JsonSerialization.readValue((String)credentialModel.getCredentialData(), SmsAuthCredentialData.class);
            SmsAuthCredentialModel smsAuthenticatorModel = new SmsAuthCredentialModel(credentialData);
            smsAuthenticatorModel.setUserLabel("Mobile Number: ***" + credentialData.getMobileNumber().substring(Math.max(credentialData.getMobileNumber().length() - 3, 0)));
            smsAuthenticatorModel.setCreatedDate(credentialModel.getCreatedDate());
            smsAuthenticatorModel.setType(TYPE);
            smsAuthenticatorModel.setId(credentialModel.getId());
            smsAuthenticatorModel.setCredentialData(credentialModel.getCredentialData());
            return smsAuthenticatorModel;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static SmsAuthCredentialModel createSmsAuthenticator(String mobileNumber) {
        SmsAuthCredentialModel credentialModel = new SmsAuthCredentialModel(mobileNumber);
        credentialModel.fillCredentialModelFields();
        return credentialModel;
    }

    public SmsAuthCredentialData getSmsAuthenticatorData() {
        return this.mobileNumber;
    }

    private void fillCredentialModelFields() {
        try {
            this.setCredentialData(JsonSerialization.writeValueAsString((Object)this.mobileNumber));
            this.setType(TYPE);
            this.setCreatedDate(Time.currentTimeMillis());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

