/*
 * Decompiled with CFR 0.152.
 */
package hive.keycloak.authenticator.gateway;

import hive.keycloak.authenticator.gateway.SmsService;
import hive.keycloak.authenticator.gateway.SmsServiceFactory;
import java.net.URI;
import java.net.URLEncoder;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.Charset;
import java.util.Base64;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;
import org.jboss.logging.Logger;

public class ApiSmsService
implements SmsService {
    private static final Logger logger = Logger.getLogger(SmsServiceFactory.class);
    private static final Pattern plusPrefixPattern = Pattern.compile("\\+");
    private final String apiurl;
    private final Boolean urlencode;
    private final String apitoken;
    private final String apiuser;
    private final String senderId;
    private final String countrycode;
    private final String apitokenattribute;
    private final String messageattribute;
    private final String receiverattribute;
    private final String receiverJsonTemplate;
    private final String senderattribute;
    private final boolean hideResponsePayload;

    ApiSmsService(Map<String, String> config) {
        this.apiurl = config.get("apiurl");
        this.urlencode = Boolean.parseBoolean(config.getOrDefault("urlencode", "false"));
        this.apitoken = config.getOrDefault("apitoken", "");
        this.apiuser = config.getOrDefault("apiuser", "");
        this.countrycode = config.getOrDefault("countrycode", "");
        this.senderId = config.get("senderId");
        this.apitokenattribute = config.getOrDefault("apitokenattribute", "");
        this.messageattribute = config.get("messageattribute");
        this.receiverattribute = config.get("receiverattribute");
        this.receiverJsonTemplate = config.getOrDefault("receiverJsonTemplate", "\"%s\"");
        this.senderattribute = config.get("senderattribute");
        this.hideResponsePayload = Boolean.parseBoolean(config.get("hideResponsePayload"));
    }

    @Override
    public void send(String phoneNumber, String message) {
        phoneNumber = ApiSmsService.clean_phone_number(phoneNumber, this.countrycode);
        Object request = null;
        HttpClient client = HttpClient.newHttpClient();
        try {
            String payload;
            HttpRequest.Builder request_builder = this.urlencode != false ? this.urlencoded_request(phoneNumber, message) : this.json_request(phoneNumber, message);
            request = this.apiuser != null && !this.apiuser.isEmpty() ? request_builder.setHeader("Authorization", ApiSmsService.get_auth_header(this.apiuser, this.apitoken)).build() : request_builder.build();
            HttpResponse<String> response = client.send((HttpRequest)request, HttpResponse.BodyHandlers.ofString());
            int statusCode = response.statusCode();
            String string = payload = this.hideResponsePayload ? "redacted" : "Response: " + response.body();
            if (statusCode >= 200 && statusCode < 300) {
                logger.infof("Sent SMS to %s [%s]", (Object)phoneNumber, (Object)payload);
            } else {
                logger.errorf("Failed to send message to %s [%s]. Validate your config.", (Object)phoneNumber, (Object)payload);
            }
        }
        catch (Exception e) {
            logger.errorf((Throwable)e, "Failed to send message to %s with request: %s. Validate your config.", (Object)phoneNumber, (Object)(request != null ? request.toString() : "null"));
        }
    }

    public HttpRequest.Builder json_request(String phoneNumber, String message) {
        String sendJson = "{" + Optional.ofNullable(this.apitokenattribute).map(it -> String.format("\"%s\":\"%s\",", it, this.apitoken)).orElse("") + String.format("\"%s\":\"%s\",", this.messageattribute, message) + String.format("\"%s\":%s,", this.receiverattribute, String.format(this.receiverJsonTemplate, phoneNumber)) + String.format("\"%s\":\"%s\"", this.senderattribute, this.senderId) + "}";
        return HttpRequest.newBuilder().uri(URI.create(this.apiurl)).header("Content-Type", "application/json").POST(HttpRequest.BodyPublishers.ofString(sendJson));
    }

    public HttpRequest.Builder urlencoded_request(String phoneNumber, String message) {
        String body = Optional.ofNullable(this.apitokenattribute).map(it -> String.format("%s=%s&", it, URLEncoder.encode(this.apitoken, Charset.defaultCharset()))).orElse("") + String.format("%s=%s&", this.messageattribute, URLEncoder.encode(message, Charset.defaultCharset())) + String.format("%s=%s&", this.receiverattribute, URLEncoder.encode(phoneNumber, Charset.defaultCharset())) + String.format("%s=%s", this.senderattribute, URLEncoder.encode(this.senderId, Charset.defaultCharset()));
        return HttpRequest.newBuilder().uri(URI.create(this.apiurl)).header("Content-Type", "application/x-www-form-urlencoded").POST(HttpRequest.BodyPublishers.ofString(body));
    }

    private static String get_auth_header(String apiuser, String apitoken) {
        String authString = apiuser + ":" + apitoken;
        String b64_cred = Base64.getEncoder().encodeToString(authString.getBytes());
        return "Basic " + b64_cred;
    }

    private static String clean_phone_number(String phone_number, String countrycode) {
        if (countrycode == null || countrycode.isEmpty()) {
            logger.infof("Clean phone number: no country code set, return %s", (Object)phone_number);
            return phone_number;
        }
        String country_number = plusPrefixPattern.matcher(countrycode).replaceFirst("");
        if (phone_number.startsWith(country_number)) {
            phone_number = phone_number.replaceFirst(country_number, countrycode);
            logger.infof("Clean phone number: convert 49 to +49, set phone number to %s", (Object)phone_number);
        }
        if (phone_number.startsWith("00" + country_number)) {
            phone_number = phone_number.replaceFirst("00" + country_number, countrycode);
            logger.infof("Clean phone number: convert 0049 to +49, set phone number to %s", (Object)phone_number);
        }
        if (phone_number.startsWith(countrycode + "0")) {
            phone_number = phone_number.replaceFirst("\\+" + country_number + "0", countrycode);
            logger.infof("Clean phone number: convert +490176 to +49176, set phone number to %s", (Object)phone_number);
        }
        if (phone_number.startsWith("0")) {
            phone_number = phone_number.replaceFirst("0", countrycode);
            logger.infof("Clean phone number: convert 0 to +49, set phone number to %s", (Object)phone_number);
        }
        return phone_number;
    }
}

